// Scroll Object
// Copyright 1998 Dan Steinman
// Available at the Dynamic Duo (http://www.dansteinman.com/dynduo/)
// June 7, 1998.  Last Updated July 6, 1998.
// In order to use this code you must keep this disclaimer

ns4 = (document.layers)? true:false
ie4 = (document.all)? true:false

function Scroll(name,x,y,width,height) {
	this.name = name
	ScrollObjects[ScrollObjects.length] = this.name
	this.x = x
	this.y = y
	this.w = width
	this.h = height
	this.url = null
	this.loaded = false
	this.refresh = false
	this.active = false
	this.mouseYnew = 0
	this.mouseYold = 0
	this.bar = new Object()
	this.arrow = new Object()
	this.arrow.active = false
	this.box = new Object()
	this.border = new Object()
	this.images = false
	this.visible = true
	this.setH = false
	this.history = new Array()
	this.historyLoc = -1
	this.historyLen = -1
	this.css = ''
	this.div = ''
	this.visibility = null
	this.zIndex = null
	this.slideInc = 7
	this.slideSpeed = 20
	this.obj = name + "Object"
	eval(this.obj + "=this")
	this.setMargins = ScrollSetMargins
	this.setMargins(10,10,10,10)
	this.setDimensions = ScrollSetDimensions
	this.setDimensions(15,15,30,1)
	this.setColors = ScrollSetColors
	this.setColors(null,"#000000","#C5C5C5","#555555","#898989")
	this.setNestInfo = ScrollSetNestInfo
	this.setNestInfo(null,0,0)
	this.preload = ScrollPreload
	this.setImages = ScrollSetImages
	this.setImages()
	this.setHeight = ScrollSetHeight
	this.build = ScrollBuild
	this.load = ScrollLoad
	this.back = ScrollBack
	this.forward = ScrollForward
	this.reload = ScrollReload
	this.activate = ScrollActivate
	this.hide = ScrollHide
	this.show = ScrollShow
	this.jumpTop = ScrollJumpTop
	this.jumpBottom = ScrollJumpBottom
	this.mouseDown = ScrollMouseDown
	this.mouseMove = ScrollMouseMove
	this.mouseUp = ScrollMouseUp
	this.slide = ScrollSlide
}
function ScrollSetDimensions(bar,arrow,box,border) {
	this.bar.v = bar
	this.arrow.v = arrow
	this.box.v = box
	this.border.v = border
	this.bar.height = this.h-2*this.border.v-this.box.v-this.arrow.v
}
function ScrollSetColors(background,border,bar,arrow,box) {
	this.bgcolor = background
	this.border.color = border
	this.bar.color = bar
	this.arrow.color = arrow
	this.box.color = box
}
function ScrollSetMargins(left,right,top,bottom) {
	this.marginLeft = left
	this.marginRight = right
	this.marginTop = top
	this.marginBottom = bottom
}
function ScrollPreload(imgObj,imgSrc) {
	if (imgSrc!=null) {
		eval(imgObj+' = new Image()')
		eval(imgObj+'.src = "'+imgSrc+'"')
		eval(imgObj+'s = true')
	}
	else eval(imgObj+'s = false')
}
function ScrollSetImages(box0,box1,arrowUp0,arrowUp1,arrowDn0,arrowDn1,bar,barHeight) {
	this.preload(this.obj+'.box.image0',box0)
	this.preload(this.obj+'.box.image1',box1)
	this.preload(this.obj+'.arrow.upimage0',arrowUp0)
	this.preload(this.obj+'.arrow.upimage1',arrowUp1)
	this.preload(this.obj+'.arrow.dnimage0',arrowDn0)
	this.preload(this.obj+'.arrow.dnimage1',arrowDn1)
	this.preload(this.obj+'.bar.image',bar)
	this.bar.imageH = barHeight
}
function ScrollSetNestInfo(nestref,x,y) {
	if (ns4 && nestref) {
		this.nestref = nestref
		this.nest = nestref+'.document.'
	}
	else {
		this.nestref = null
		this.nest = ''
	}
	this.nestX = x
	this.nestY = y
	this.ref = this.nest+this.name+'Div.document.'+this.name+'TextCtr.document.'+this.name+'TextDiv'
}
function ScrollBuild() {
	var nm = this.name
	var b = this.border.v
	var a = this.arrow.v
	var br = this.bar.v
	var bx = this.box.v
	var ml = this.marginLeft
	var mr = this.marginRight
	var mt = this.marginTop
	this.refX = this.x+b+ml
	this.refY = this.y+b+mt
	var pa = ' {position:absolute'
	var l = '; left:'
	var t = '; top:'
	var w = '; width:'
	var h = '; height:'
	var c = '; clip:rect(0,'
	var ec = ',0); '
	var h2b = this.h-2*b
	var ibc = 'background-color:'
	var nbc = '; layer-background-color:'
	var tw = ""+this.w-br-2*b-ml-mr
	var bgc = (this.bgcolor!=null) ? ibc+this.bgcolor+nbc+this.bgcolor : ''
	var bdc = (this.border.color!=null) ? ibc+this.border.color+nbc+this.border.color : ''
	var barc = (this.bar.color!=null) ? ibc+this.bar.color+nbc+this.bar.color : ''
	var boxc = (this.box.color!=null) ? ibc+this.box.color+nbc+this.box.color : ''
	var arc = (this.arrow.color!=null) ? ibc+this.arrow.color+nbc+this.arrow.color : ''
	end = ';}\n'
	var vis = (this.visibility!=null)? '; visibility:'+this.visibility : ''
	var z = (this.zIndex!=null)? '; z-index:'+this.zIndex : ''
	this.css = '<STYLE TYPE="text/css">\n'+
	'#'+nm+'Div'+pa+l+this.x+t+this.y+w+this.w+h+this.h+c+this.w+','+this.h+ec+bgc+vis+z+end+
	'#'+nm+'BorderTop'+pa+w+this.w+h+b+c+this.w+','+b+ec+bdc+end+
	'#'+nm+'BorderBottom'+pa+t+(this.h-b)+w+this.w+h+b+c+this.w+','+b+ec+bdc+end+
	'#'+nm+'BorderLeft'+pa+w+b+h+this.h+c+b+','+this.h+ec+bdc+end+
	'#'+nm+'BorderRight'+pa+l+(this.w-b)+w+b+h+this.h+c+b+','+this.h+ec+bdc+end+
	'#'+nm+'BarDiv'+pa+l+(this.w-b-br)+t+b+w+br+h+h2b+c+br+','+h2b+ec+barc+'; visibility:hidden'+end+
	'#'+nm+'BoxDiv'+pa+t+a+w+br+h+bx+c+br+','+bx+ec+boxc+end+
	'#'+nm+'ArrowUpDiv'+pa+l+0+t+0+w+br+h+a+c+br+','+a+ec+arc+end+
	'#'+nm+'ArrowDnDiv'+pa+l+0+t+(h2b-a)+w+br+h+a+c+br+','+a+ec+arc+end+
	'#'+nm+'BarCover'+pa+l+0+t+0+w+br+h+h2b+c+br+','+h2b+ec+'}\n'+
	'#'+nm+'TextCtr'+pa+l+(b+ml)+t+b+w+tw+h+h2b+c+tw+','+h2b+ec+'}\n'+
	'#'+nm+'TextDiv'+pa+t+mt+w+tw+end+
	'</STYLE>'
	this.div = ''
	if (ie4) this.div += '<IFRAME NAME="'+this.name+'Frame" WIDTH=0 HEIGHT=0 STYLE="display:none"></IFRAME>\n'
	this.div += '<DIV ID="'+nm+'Div">\n'+
	'<DIV ID="'+nm+'BarDiv">\n'
	this.div += (this.bar.images)? '<IMG SRC="'+this.bar.image.src+'" WIDTH="'+this.bar.v+'" HEIGHT="'+this.bar.imageH+'">':''
	this.div += '\n<DIV ID="'+nm+'BoxDiv">'
	this.div += (this.box.image0s)? '<IMG NAME="'+nm+'BoxImg" SRC="'+this.box.image0.src+'">':''
	this.div += '</DIV>\n<DIV ID="'+nm+'ArrowUpDiv">'
	this.div += (this.arrow.upimage0s)? '<IMG NAME="'+nm+'ArrowUpImg" SRC="'+this.arrow.upimage0.src+'">':''
	this.div += '</DIV>\n<DIV ID="'+nm+'ArrowDnDiv">'
	this.div += (this.arrow.dnimage0s)? '<IMG NAME="'+nm+'ArrowDnImg" SRC="'+this.arrow.dnimage0.src+'">':''
	this.div += '</DIV>\n'+
	'<DIV ID="'+nm+'BarCover"></DIV>\n'+
	'</DIV>\n'+
	'<DIV ID="'+nm+'BorderTop"></DIV>\n'+
	'<DIV ID="'+nm+'BorderBottom"></DIV>\n'+
	'<DIV ID="'+nm+'BorderLeft"></DIV>\n'+
	'<DIV ID="'+nm+'BorderRight"></DIV>\n'+
	'<DIV ID="'+nm+'TextCtr">\n'+
	'<DIV ID="'+nm+'TextDiv">\n'
	this.divStart = this.div
	this.divEnd = '</DIV></DIV></DIV>'
	this.div += this.divEnd
	document.write(this.css)
}
function ScrollLoad(url) {
	if (url != this.url) {
		this.historyLoc += 1
		this.historyLen = this.historyLoc
		this.history[this.historyLen] = url
		this.reload()
	}
}
function ScrollBack() {
	if (this.historyLoc > 0) {
		this.historyLoc -= 1
		this.reload()
	}
}
function ScrollForward() {
	if (this.historyLoc < this.historyLen) {
		this.historyLoc += 1
		this.reload()
	}
}
function ScrollReload() {
	this.url = this.history[this.historyLoc]
	this.refresh = true
	if (ns4) eval('document.'+this.nest+this.name+'Div.document.'+this.name+'TextCtr.document.'+this.name+'TextDiv.src = "'+this.url+'"')
	else if (ie4) parent.frames[this.name+'Frame'].document.location = this.url
}
ScrollObjects = new Array()
function ScrollRefresh() {
	for (var i=0;i<ScrollObjects.length;i++) {
		if (eval(ScrollObjects[i]+".refresh")) {
			eval(ScrollObjects[i]+".activate()")
		}
	}
}
function ScrollSetHeight(height) {
	this.newHeight = height
	this.setH = true
	this.activate()
}
function ScrollActivate() {
	if (this.refresh) {
		this.refresh = false
		if (ie4) document.all[this.name+'TextDiv'].innerHTML = parent.frames[this.name+'Frame'].document.body.innerHTML
	}
	this.lyr = new DynLayer(this.name+'Div',this.nestref)
	this.textlyr = new DynLayer(this.name+'TextDiv',this.nest+this.name+'Div.document.'+this.name+'TextCtr')
	this.boxlyr = new DynLayer(this.name+'BoxDiv',this.nest+this.name+'Div.document.'+this.name+'BarDiv')
	this.arrowuplyr = new DynLayer(this.name+'ArrowUpDiv',this.nest+this.name+'Div.document.'+this.name+'BarDiv')
	this.arrowdnlyr = new DynLayer(this.name+'ArrowDnDiv',this.nest+this.name+'Div.document.'+this.name+'BarDiv')
	this.barlyr = new DynLayer(this.name+'BarDiv',this.nest+this.name+'Div')
	if (ns4) {
		this.textlyr.css.clip.right = this.w-this.bar.v-2*this.border.v-this.marginLeft-this.marginRight
		if (!this.setH) {
			this.textlyr.height = this.textlyr.doc.height
			this.textlyr.css.clip.bottom = Math.max(this.textlyr.height,this.h-2*this.border.v-this.marginTop)
		}
		else {
			this.textlyr.height = this.newHeight
			this.textlyr.css.clip.bottom = this.newHeight
			this.setH = false
		}
	}
	else if (ie4) {
		if (!this.setH) this.textlyr.height = document.all[this.name+"TextDiv"].scrollHeight
		else {
			this.textlyr.height = this.newHeight
			this.setH = true
		}
	}
	this.ratio = (this.textlyr.height+this.marginTop+this.marginBottom-this.h+2*this.border.v)/(this.bar.height-this.arrow.v)
	this.jumpTop()
	if (this.ratio>0) {
		this.loaded = true
		if (this.visibility!='hidden') this.barlyr.show()
	}
	else {
		this.loaded = false
		this.barlyr.hide()
	}
}
function ScrollHide() {
	this.visibility = 'hidden'
	this.lyr.hide()
	this.barlyr.hide()
}
function ScrollShow() {
	this.visibility = 'visible'
	this.lyr.show()
	if (this.ratio>0) this.barlyr.show()
}
function ScrollJumpTop() {
	this.boxlyr.moveTo(0,this.arrow.v)
	this.textlyr.moveTo(0,this.marginTop)
}
function ScrollJumpBottom() {
	this.boxlyr.moveTo(0,this.bar.height)
	this.textlyr.moveTo(0,-this.ratio*(this.boxlyr.y-this.arrow.v)+this.marginTop)
}
function ScrollMouseDown(x,y) {
	var b = this.border.v
	var a = this.arrow.v
	var br = this.bar.v
	var bx = this.box.v
	var xr = this.x+this.nestX
	var yr = this.y+this.nestY
	var brl = xr+this.w-b-br
	if (this.ratio>0 && x>brl && x<brl+br && y>=yr+b && y<yr+this.h-b) {
		var bxt = yr+b+this.boxlyr.y
		if (y>=bxt && y<bxt+bx) {
			if (this.box.image1s) this.boxlyr.doc.images[this.name+"BoxImg"].src = this.box.image1.src
			this.clickYnew = y-this.boxlyr.y
			this.clickYold = y
			this.active = true
		}			
		else if (y<yr+b+a) {
			if (this.arrow.upimage1s) this.arrowuplyr.doc.images[this.name+"ArrowUpImg"].src = this.arrow.upimage1.src
			this.arrow.dir = 1
			this.arrow.active = true
			this.slide()
		}
		else if (y>=yr+this.h-b-a) {
			if (this.arrow.dnimage1s) this.arrowdnlyr.doc.images[this.name+"ArrowDnImg"].src = this.arrow.dnimage1.src
			this.arrow.dir = -1
			this.arrow.active = true
			this.slide()
		}
		else {
			if (y<=yr+b+a+bx/2) this.boxlyr.moveTo(0,a)
			else if (y>yr+this.h-b-a-bx/2) this.boxlyr.moveTo(0,this.bar.height)
			else this.boxlyr.moveTo(0,y-this.y-this.nestY-b-bx/2)
			if (this.box.image1s) this.boxlyr.doc.images[this.name+"BoxImg"].src = this.box.image1.src
			this.textlyr.moveTo(0,-this.ratio*(this.boxlyr.y-a)+this.marginTop)
			this.clickYnew = y-this.boxlyr.y
			this.clickYold = y
			this.active = true
		}
	}
}
function ScrollMouseUp() {
	this.active = false
	this.arrow.active = false
	this.refY = this.y+this.border.v+Math.floor(this.textlyr.y)
	if (this.box.image1s) this.boxlyr.doc.images[this.name+"BoxImg"].src = this.box.image0.src
	if (this.arrow.upimage1s)this.arrowuplyr.doc.images[this.name+"ArrowUpImg"].src = this.arrow.upimage0.src
	if (this.arrow.dnimage1s)this.arrowdnlyr.doc.images[this.name+"ArrowDnImg"].src = this.arrow.dnimage0.src
}
function ScrollMouseMove(x,y) {
	if (!this.active) return
	var diff = y-this.clickYold
	var a = this.arrow.v
	var bxy = this.boxlyr.y
	var brh = this.bar.height
	if ((bxy>a && bxy<brh) || (bxy==a && diff>=0) || (bxy==brh && diff<=0)) {
		if ((bxy>a && bxy+diff<a) || (bxy<brh && bxy+diff>brh)) {
			if (bxy+diff<a) this.boxlyr.moveTo(0,a)
			else if (bxy+diff>brh) this.boxlyr.moveTo(0,brh)
			this.clickYold = bxy+this.clickYnew
		}
		else {
			this.boxlyr.moveTo(0,y-this.clickYnew)
			this.clickYold = y
		}
		this.textlyr.moveTo(0,-this.ratio*(this.boxlyr.y-a)+this.marginTop)
	}
}
function ScrollSlide() {
	if (this.arrow.active) {
		if ((this.arrow.dir==1 && this.textlyr.y<this.marginTop-this.slideInc) || (this.arrow.dir==-1 && this.textlyr.y>-(this.textlyr.height+2*this.border.v+this.marginBottom-this.h-this.slideInc))) {
			this.textlyr.moveBy(0,this.arrow.dir*this.slideInc)
			this.boxlyr.moveTo(0,(this.textlyr.y-this.marginTop)/-this.ratio+this.arrow.v)
			setTimeout(this.obj+".slide()",this.slideSpeed)
		}
		else {
			if (this.arrow.dir==1) this.textlyr.moveTo(0,this.marginTop)
			else if (this.arrow.dir==-1) this.textlyr.moveTo(0,-(this.textlyr.height+2*this.border.v+this.marginBottom-this.h))
			this.boxlyr.moveTo(0,(this.textlyr.y-this.marginTop)/-this.ratio+this.arrow.v)
		}
	}
}