// Dynamic Layer Object
// Copyright 1998 Dan Steinman
// Available at the Dynamic Duo (http://www.dansteinman.com/dynduo/)
// February 1998.  Last Updated Aug. 10, 1998.
// In order to use this code you must keep this disclaimer

ns4 = (document.layers)? true:false
ie4 = (document.all)? true:false

function DynLayer(id,nestref) {
	if (ns4) {
		this.css = (nestref)? eval("document."+nestref+".document."+id) : document.layers[id]
		this.x = this.css.left
		this.y = this.css.top
	}
	else if (ie4) {
		this.css = document.all[id].style
		this.x = this.css.pixelLeft
		this.y = this.css.pixelTop
	}
	this.moveTo = DynLayerMoveTo
	this.moveBy = DynLayerMoveBy
	this.show = DynLayerShow
	this.hide = DynLayerHide
	this.addon = DynLayerAddon
	this.addon(id,nestref)
}
function DynLayerMoveTo(x,y) {
	if (x!=null) {
		this.x = x
		this.css.left = this.x
	}
	if (y!=null) {
		this.y = y
		this.css.top = this.y
	}
}
function DynLayerMoveBy(x,y) {
	this.moveTo(this.x+x,this.y+y)
}
function DynLayerShow() {
	this.css.visibility = (ns4)? "show" : "visible"
}
function DynLayerHide() {
	this.css.visibility = (ns4)? "hide" : "hidden"
}
function DynLayerAddon(id,nestref) {
	this.id = id
	this.nestref = nestref
	this.w = (ns4)? this.css.clip.width : this.css.pixelWidth
	this.h = (ns4)? this.css.clip.height : this.css.pixelHeight
	this.doc = (ns4)? this.css.document : document
	this.event = (ns4)? this.css : document.all[id]
	this.obj = id + "DynLayer"
	eval(this.obj + "=this")
	this.slideInit = DynLayerSlideInit
	this.clipInit = DynLayerClipInit
	this.wipeInit = DynLayerWipeInit
}
function DynLayerSlideInit() {
	this.slideTo = DynLayerSlideTo
	this.slideBy = DynLayerSlideBy
	this.slideStart = DynLayerSlideStart
	this.slide = DynLayerSlide
}
function DynLayerSlideTo(endx,endy,inc,speed,fn) {
	if (endx==null) endx = this.x
	if (endy==null) endy = this.y
	var distx = endx-this.x
	var disty = endy-this.y
	this.slideStart(endx,endy,distx,disty,inc,speed,fn)
}
function DynLayerSlideBy(distx,disty,inc,speed,fn) {
	var endx = this.x + distx
	var endy = this.y + disty
	this.slideStart(endx,endy,distx,disty,inc,speed,fn)
}
function DynLayerSlideStart(endx,endy,distx,disty,inc,speed,fn) {
	if (this.slideActive) return
	var num = Math.sqrt(Math.pow(distx,2) + Math.pow(disty,2))/inc
	var dx = distx/num
	var dy = disty/num
	if (!fn) fn = null
	this.slideActive = true
	this.slide(dx,dy,endx,endy,num,1,speed,fn)
}
function DynLayerSlide(dx,dy,endx,endy,num,i,speed,fn) {
	if (!this.slideActive) return
	if (i++ < num) {
		this.moveBy(dx,dy)
		setTimeout(this.obj+".slide("+dx+","+dy+","+endx+","+endy+","+num+","+i+","+speed+",\""+fn+"\")",speed)
	}
	else {
		this.slideActive = false
		this.moveTo(endx,endy)
		eval(fn)
	}
}
function DynLayerClipInit(clipTop,clipRight,clipBottom,clipLeft) {
	this.clipTo = DynLayerClipTo
	this.clipBy = DynLayerClipBy
	this.clipValues = DynLayerClipValues
	if (ie4) {
		if (arguments.length==4) this.clipTo(clipTop,clipRight,clipBottom,clipLeft)
		else this.clipTo(0,this.w,this.h,0)
	}
}
function DynLayerClipTo(t,r,b,l) {
	if (t==null) t = this.clipValues('t')
	if (r==null) r = this.clipValues('r')
	if (b==null) b = this.clipValues('b')
	if (l==null) l = this.clipValues('l')
	if (ns4) {
		this.css.clip.top = t
		this.css.clip.right = r
		this.css.clip.bottom = b
		this.css.clip.left = l
	}
	else if (ie4) this.css.clip = "rect("+t+"px "+r+"px "+b+"px "+l+"px)"
}
function DynLayerClipBy(t,r,b,l) {
	this.clipTo(this.clipValues('t')+t,this.clipValues('r')+r,this.clipValues('b')+b,this.clipValues('l')+l)
}
function DynLayerClipValues(which) {
	if (ie4) var clipv = this.css.clip.split("rect(")[1].split(")")[0].split("px")
	if (which=="t") return (ns4)? this.css.clip.top : Number(clipv[0])
	if (which=="r") return (ns4)? this.css.clip.right : Number(clipv[1])
	if (which=="b") return (ns4)? this.css.clip.bottom : Number(clipv[2])
	if (which=="l") return (ns4)? this.css.clip.left : Number(clipv[3])
}
function DynLayerWipeInit(clipTop,clipRight,clipBottom,clipLeft) {
	if (arguments.length==4) this.clipInit(clipTop,clipRight,clipBottom,clipLeft)
	else this.clipInit()
	this.wipeTo = DynLayerWipeTo
	this.wipeBy = DynLayerWipeBy
	this.wipeStart = DynLayerWipeStart
	this.wipe = DynLayerWipe
}
function DynLayerWipeTo(endt,endr,endb,endl,num,speed,fn) {
	var distt = (endt!=null)? endt-this.clipValues('t'):0
	var distr = (endr!=null)? endr-this.clipValues('r'):0
	var distb = (endb!=null)? endb-this.clipValues('b'):0
	var distl = (endl!=null)? endl-this.clipValues('l'):0
	this.wipeStart(distt,distr,distb,distl,endt,endr,endb,endl,num,speed,fn)
}
function DynLayerWipeBy(distt,distr,distb,distl,num,speed,fn) {
	this.wipeStart(distt,distr,distb,distl,distt+this.clipValues('t'),distr+this.clipValues('r'),distb+this.clipValues('b'),distl+this.clipValues('l'),num,speed,fn)
}
function DynLayerWipeStart(distt,distr,distb,distl,endt,endr,endb,endl,num,speed,fn) {
	if (this.wipeActive) return
	if (!fn) fn = null
	this.wipeActive = true
	this.wipe(distt/num,distr/num,distb/num,distl/num,endt,endr,endb,endl,this.clipValues('t'),this.clipValues('r'),this.clipValues('b'),this.clipValues('l'),num,1,speed,fn)
}
function DynLayerWipe(dt,dr,db,dl,endt,endr,endb,endl,st,sr,sb,sl,num,i,speed,fn) {
	if (!this.wipeActive) return
	if (i++ < num) {
		this.clipTo(st+i*dt,sr+i*dr,sb+i*db,sl+i*dl)
		setTimeout(this.obj+".wipe("+dt+","+dr+","+db+","+dl+","+endt+","+endr+","+endb+","+endl+","+st+","+sr+","+sb+","+sl+","+num+","+i+","+speed+",\""+fn+"\")",speed)
	}
	else {
		this.wipeActive = false
		this.clipTo(endt,endr,endb,endl)
		eval(fn)	
	}
}
function DynLayerInit(nestref) {
	if (ns4) {
		if (nestref) ref = eval('document.'+nestref+'.document')
		else {nestref = ''; ref = document;}
		for (var i=0; i<ref.layers.length; i++) {
			var divname = ref.layers[i].name
			var index = divname.indexOf("Div")
			if (index > 0) {
				eval(divname.substr(0,index)+' = new DynLayer("'+divname+'","'+nestref+'")')
			}
			if (ref.layers[i].document.layers.length > 0) {
				DynLayerInit.refArray[DynLayerInit.refArray.length] = (nestref=='')? ref.layers[i].name : nestref+'.'+ref.layers[i].name
			}
		}
		if (DynLayerInit.refArray.i < DynLayerInit.refArray.length) {
			DynLayerInit(DynLayerInit.refArray[DynLayerInit.refArray.i++])
		}
	}
	else if (ie4) {
		for (var i=0; i<document.all.tags("DIV").length; i++) {
			var divname = document.all.tags("DIV")[i].id
			var index = divname.indexOf("Div")
			if (index > 0) {
				eval(divname.substr(0,index)+' = new DynLayer("'+divname+'")')
			}
		}
	}
	return true
}
DynLayerInit.refArray = new Array()
DynLayerInit.refArray.i = 0
